function UpdateSpec(handles,image,No)

%% Get Handles
Axes      = get(handles.Load,'UserData');
Energies  = get(handles.ZLPAlign,'UserData');
Data      = get(handles.Spec,'UserData');
NormImg   = get(handles.NormImg,'Value');
spec      = Data{1};
pos_rect  = Data{2};
OldEne    = Data{4};
specdiff  = Data{5};
pos       = pos_rect;

%% Calculate

YScale = size(image,1)*(Axes(2)/2);
XScale = size(image,2)*(Axes(1)/2);

pos_rect(1) = round(( pos_rect(1)+XScale)/Axes(1)+1);                      % translates the selected rectangle position
pos_rect(2) = round((-pos_rect(2)+YScale)/Axes(2)+1);                      % into pixel numbers
pos_rect(3) = round(pos_rect(3)/Axes(1));
pos_rect(4) = round(pos_rect(4)/Axes(2));


xmin =  pos_rect(1);
ymin = (pos_rect(2)-pos_rect(4));
xmax = (pos_rect(1)+pos_rect(3));
ymax =  pos_rect(2);


if xmin<1
    xmin     = 1;
end


if ymin<1
    ymin     = 1;
end


if xmax>size(image,2)
    xmax     = size(image,2);
end


if ymax>size(image,1)
    ymax     = size(image,1);
end

if xmin>xmax
    xmin=xmax;
end

if ymin>ymax
    ymin=ymax;
end

Pos       = [xmin,ymin,xmax,ymax];

Spec      = reshape(image(Pos(2):Pos(4),Pos(1):Pos(3),:),[(Pos(4)-Pos(2)+1)*(Pos(3)-Pos(1)+1),size(image,3)]);
Spec      = mean(Spec,1);
OldEne{No}= Spec;
Color=['k','m','c','y','r','b','g'];
figure(spec);
gca;


for i=1:length(OldEne)
    Spec     = OldEne{i};
    if NormImg==0
        plot(Energies,Spec,Color(i),'LineWidth',1.5);
        ylim([0, max(Spec)]);
        ylabel( 'Intensity [Counts]' );
    else
        plot(Energies,Spec,Color(i),'LineWidth',1.5);
        ylim([0, max(Spec)]);
        ylabel( 'Loss propability [a.u.]' );
    end
    xlabel( 'Electron energy-loss [eV]' );
    title('EEL-Spectrum');
    set(gca,'FontSize',18);
    hold on
end
hold off


if length(OldEne)>1
    figure(specdiff);
    gca;
    
    for i=2:length(OldEne)
        SpecDiff     =OldEne{i}(1,:)-OldEne{1}(1,:);
        if NormImg==0
            plot(Energies,SpecDiff,Color(i),'LineWidth',1.5);
            MaxDiff = max(SpecDiff);
            if MaxDiff>0
                ylim([0,MaxDiff ]);
            end
            ylabel( 'Intensity [Counts]' );
        else
            MaxDiff= max(SpecDiff);
            plot(Energies,SpecDiff,Color(i),'LineWidth',1.5);
            if MaxDiff>0
                ylim([0, MaxDiff]);
            end
            ylabel( 'Loss propability [a.u.]' );
        end
        xlabel( 'Electron energy-loss [eV]' );
        set(gca,'FontSize',18);
        hold on
        title('Differences');
    end
    hold off
else
    specdiff=[];
end

Data={spec,pos,No,OldEne,specdiff};
set(handles.Spec,'UserData',Data);

clearvars all
end